/************************************************************************************
* This file contains the functions related to the display on the hyperterminal,
* as well as explanations on the frame format.
*
*
* (c) Copyright 2012, Freescale Semiconductor, Inc. All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
************************************************************************************/

/*********************************************
* Includes
*********************************************/
#include "FunctionLib.h"
#include "UART_Interface.h"
#include "main.h"




/*********************************************
* SendDataToHyperterminal                    *
* See description and information            *
* in the header file                         *
*********************************************/
void SendDataToHyperterminal(unsigned char tmpbuf[],uint8_t gau8RxDataBuffer[], uint16_t counter, uint8_t Frame_Verification_Result)
{
  unsigned char hex_word[16] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};

     tmpbuf[0] = hex_word[(gau8RxDataBuffer[4] >> 4) &0x0f]; // Tire ID
     tmpbuf[1] = hex_word[gau8RxDataBuffer[4] &0x0f];
     tmpbuf[2] = hex_word[(gau8RxDataBuffer[5] >> 4)&0x0f]; // Pressure
     tmpbuf[3] = hex_word[(gau8RxDataBuffer[5] & 0x0f)];
     tmpbuf[4] = hex_word[(gau8RxDataBuffer[6] >> 4)&0x0f]; // Pressure
     tmpbuf[5] = hex_word[(gau8RxDataBuffer[6] & 0x0f)];
     tmpbuf[6] = hex_word[(gau8RxDataBuffer[7] >> 4)&0x0f]; // Z accel
     tmpbuf[7] = hex_word[(gau8RxDataBuffer[7] & 0x0f)];
     tmpbuf[8] = hex_word[(gau8RxDataBuffer[8] >> 4)&0x0f]; // Pressure
     tmpbuf[9] = hex_word[(gau8RxDataBuffer[8] & 0x0f)];
     tmpbuf[10] = hex_word[(gau8RxDataBuffer[9] >> 4)&0x0f]; // Pressure
     tmpbuf[11] = hex_word[(gau8RxDataBuffer[9] & 0x0f)];
     tmpbuf[12] = hex_word[(gau8RxDataBuffer[10] >> 4)&0x0f]; // Z accel
     tmpbuf[13] = hex_word[(gau8RxDataBuffer[10] & 0x0f)];
     tmpbuf[14] = hex_word[(gau8RxDataBuffer[11] >> 4)&0x0f]; // Z accel
     tmpbuf[15] = hex_word[(gau8RxDataBuffer[11] & 0x0f)];
     tmpbuf[16] = hex_word[(gau8RxDataBuffer[12] >> 4)&0x0f]; // X accel
     tmpbuf[17] = hex_word[(gau8RxDataBuffer[12] & 0x0f)];
     tmpbuf[18] = hex_word[(gau8RxDataBuffer[13] >> 4)&0x0f]; // X accel
     tmpbuf[19] = hex_word[(gau8RxDataBuffer[13] & 0x0f)];
     tmpbuf[20] = hex_word[(gau8RxDataBuffer[14] >> 4)&0x0f]; // Volt
     tmpbuf[21] = hex_word[(gau8RxDataBuffer[14] & 0x0f)];  
     tmpbuf[22] = hex_word[(gau8RxDataBuffer[15] >> 4)&0x0f]; // Temp
     tmpbuf[23] = hex_word[(gau8RxDataBuffer[15] & 0x0f)];
     tmpbuf[24] = hex_word[(gau8RxDataBuffer[16] >> 4)&0x0f]; // Status Acq
     tmpbuf[25] = hex_word[(gau8RxDataBuffer[16] & 0x0f)];
     tmpbuf[26] = hex_word[(Frame_Verification_Result >> 4)&0x0f]; // Frame Verification Result (refer to header file)
     tmpbuf[27] = hex_word[(Frame_Verification_Result & 0x0f)];
     tmpbuf[28] = hex_word[(counter >> 12)&0x0f]; // Cnt
     tmpbuf[29] = hex_word[(counter >> 8)&0x0f];
     tmpbuf[30] = hex_word[(counter >> 4)&0x0f]; 
     tmpbuf[31] = hex_word[(counter)&0x0f];

     
     (void)UartX_Transmit(&tmpbuf[0], 32, UartTxCallBack);
     while (UartX_IsTxActive());
                         
}

/*********************************************
* SendMessageToHyperterminal                 *
*********************************************/

void SendMessageToHyperterminal (uint8_t *ptr_data,uint8_t len)
{
 (void)UartX_Transmit(ptr_data, len, UartTxCallBack);
 while (UartX_IsTxActive());
 (void)UartX_Transmit("\n\r", 2, UartTxCallBack);
 while (UartX_IsTxActive());
}

